LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
PACKAGE shift_types IS
   SUBTYPE bit4 IS std_logic_vector(3 downto 0);
 END shift_types;


USE WORK.shift_types.ALL;
LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
ENTITY shifter IS
  PORT( din : IN bit4;
         clk, load, left_right : IN std_logic;
         dout : INOUT bit4);
END shifter;

ARCHITECTURE synth OF shifter IS
  SIGNAL shift_val : bit4;
BEGIN
  nxt: PROCESS(load, left_right, din, dout)
  BEGIN
    IF (load = '1') THEN
      shift_val <= din;
    ELSIF (left_right = '0') THEN
      shift_val(2 downto 0) <= dout(3 downto 1);
      shift_val(3) <= '0';
    ELSE
      shift_val(3 downto 1) <= dout(2 downto 0);
      shift_val(0) <= '0';
    END IF;
  END PROCESS;

  current: PROCESS
  BEGIN
    WAIT UNTIL clk'EVENT AND clk = '1';

    dout <= shift_val;
  END PROCESS;
END synth;

